#!/bin/bash
# Updater linux du mod StargateTC 2 ( www.stargatetc2.com )
# Version 0.2 By Wolfox

# Paramètres : -debug , -dir pour préciser le repertoire de dl (repertoire par défaut = repertoire du script)
# -update pour redl à partir d'une certaine update, -unofficial pour le contenu non officiel

getInfoXML()
{
	#on récupere l'info demandée à la ligne demandée, et on enleve le saut de ligne.
	echo -n `grep package unofficial.xml | sed "s/<\/$1>/%/" | cut -d'%' -f1 | sed "s/<$1>/%/" | cut -d'%' -f2 | awk "NR == (($2+1)) {print;}"`
}

echo
echo "Bienvenue dans l'updater console du mod StargateTC 2 ! ( www.stargatetc2.com )"
echo

rep="."
updateLocale=0
silence="-q"
mode="updater"

#Check des arguments

while [ $# != 0 ] ; do
	if [ "$1" = "-dir" ] ; then
	{
		
		if [ -d "$2" ] ; then
		{
			rep=$2
		}
		else
		{
			echo "Le repertoire indiqué n'existe pas."
			exit 4
		}
		fi
	}
	elif [ "$1" = "-update" ] ; then
	{
		updateLocale=$2
		rm -f updates.txt
	}
	elif [ "$1" = "-debug" ] ; then
	{
		silence=""
	}
	elif [ "$1" = "-unofficial" ] ; then
	{
		mode="unofficial"
	}
	elif [ "$1" = "-h" ] || [ "$1" = "-help" ] ; then
	{
		echo "StargateTC 2 Updater, outil permettant de garder la version serveur linux du mod StargateTC 2 à jour."
		echo
		echo "Les paramètres de lancement sont les suivants :"
		echo
		echo "-h pour l'aide mémoire"
		echo "-debug pour voir le fonctionnement en détail"		
		echo "-dir X pour préciser de répertoire de téléchargement des mises à jour (par défaut, le répertoire courant est utilisé)"
		echo "-update X pour retélécharger les mises à jour à partir de l'update X"
		echo "-unofficial pour télécharger des créations de la communauté"
		echo
		echo "Ce script nécessite, entre autres, que unzip soit installé."
		echo
		exit 0;
	}	
	fi

	shift #décalage des arguments
done

if [ $mode = "updater" ] ; then
{
	if [ -e "updates.txt" ] ; then
	{
		updateLocale=`cat updates.txt`
	}
	fi

	echo "L'update locale est $updateLocale."
	echo
	echo "Vérification de nouvelles mises à jour..."

	wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getMaintenance" -O "status.txt"
	if [ "`cat status.txt`" != "off" ] ; then
	{
		echo "Il semblerait que le serveur soit en maintenance. Attendez un peu avant de relancer cet updater."
		echo "Si le problème persiste, vous pouvez demander de l'aide sur www.stargatetc2.com"
	}
	fi
	rm -f "status.txt"


	#Récupération du numéro de la derniere maj
	wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getVersion" -O "updatesonline.txt"

	if [ $? != 0 ] ; then
	{
		echo "Erreur de vérification de la dernière mise à jour."
		exit 3
	}
	fi

	updateActuelle=`cat updatesonline.txt`
	rm -f "updatesonline.txt"

	echo "Le numéro de la mise à jour actuelle est : $updateActuelle"
	echo


	if [ $updateLocale = $updateActuelle ] ; then
	{
		echo "Pas de nouvelle mise à jour."
		echo
		exit 0
	}
	fi


	# Obtention du miroir
	wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getMirroirPrincipale" -O "miroir.txt"
	miroir=`cat miroir.txt`
	rm -f "miroir.txt"

	# Taille totale des updates à faire :
	
	wget $silence "http://stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getTaille&version=$updateLocale" -O "taille.txt"
	total=`cat taille.txt`

	# Téléchargement des updates

	while [ $updateLocale -lt $updateActuelle ] ; do
		let "updateLocale++"

		wget $silence "http://stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getTaille&version=$((updateLocale-1))" -O "taille.txt"
		taille=`cat taille.txt`

		let "pourcentage=100-(taille*100/total)"

		fichierUpdate="update_$updateLocale.zip"
	
		lien="${miroir}package_sgtc2/$fichierUpdate"

		echo "Téléchargement de l'update $updateLocale. (Avancement total : ${pourcentage}%)"
		wget $silence $lien -O "$rep/$fichierUpdate"

		if [ $? != 0 ] ; then
		{
			echo "Erreur de téléchargement. Recommencez plus tard."
			rm -f "$rep/$fichierUpdate"
			exit 1
		}
		fi

		echo "Téléchargement terminé. Décompression..."
		unzip -u $silence "$rep/$fichierUpdate" -d "$rep"

		if [ $? != 0 ] ; then
		{
			echo "Erreur de décompression"
			exit 2
		}
		fi

		#vérification des fichiers à suppr
		wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getFichiersEffacer&version=$updateLocale" -O "listeSuppr.txt"

		grep fichier listeSuppr.txt | sed 's/\\/\//g' | sed "s/<fichier>//" | sed "s/<\/fichier>//" | sed "s/<repertoire>\///" | sed "s/<\/repertoire>//" | sed "s/<nom>//" | sed "s/<\/nom>//" > listeSuppr.txt
		rm -f `cat listeSuppr.txt`

		rm -f "$rep/$fichierUpdate" "listeSuppr.txt"
		echo "Update $updateLocale terminée."
	
	done

	rm -f "taille.txt"

	echo -n "$updateLocale" > updates.txt #sauvegarde du numero d'update

	echo
	echo "Update terminée !"
}
elif [ $mode = "unofficial" ] ; then
{
	echo "Liste du contenu non officiel disponible :"
	echo

	wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getPackages&langue=fr" -O "unofficial.xml"
	if [ $? != 0 ] ; then
	{
		echo "Erreur d'obtiention de la liste. Essayez de recommencer plus tard. Si le problème persiste, n'hésitez pas à demander de l'aide sur www.stargatetc2.com ."
		exit 1
	}
	fi

	#nombre de lignes d'infos du fichier xml :
	lignes=`grep package unofficial.xml | sed "s/<\/$1>/%/" | cut -d'%' -f1 | sed "s/<$1>/%/" | cut -d'%' -f2 | awk 'END {print NR}'`
	
	#Affiche les contenus de la façon suivante : " 1- Map sg_gnu : une map de gnu (par Chuck Norris, version 42). Note : 5/5 "
	i=0
	while [ $i -lt $lignes ] ; do
		
		let "numero=i+1"
		echo -n "$numero- "
		getInfoXML "type" $i
		echo -n " "
		getInfoXML "nomMap" $i
		echo -n " : "
		getInfoXML "description" $i
		echo -n " (par "
		getInfoXML "auteur" $i
		echo -n ", version "
		getInfoXML "version" $i		
		echo -n "). Note : "
		getInfoXML "note" $i
		echo "/5."
		let "i++"		
	done

	echo

	let "choix=lignes+1"
	while [ $choix -gt $lignes  ] || [ $choix -lt 1 ] ; do
		echo -n "Votre choix ? "
		read choix
	done

	echo "Téléchargement du contenu choisi..."
	wget $silence `getInfoXML "urlDownload" $((choix-1))` -O "$rep/unofficial.zip"
	if [ $? != 0 ] ; then
	{
		echo "Erreur de téléchargement. Recommencez plus tard."
		rm -f "$rep/unofficial.zip"
		exit 1
	}
	fi
	echo "Téléchargement terminé. Décompression..."

	unzip -u $silence "$rep/unofficial.zip" -d "$rep"
	if [ $? != 0 ] ; then
	{
		echo "Erreur de décompression"
		exit 2
	}
	fi

	rm -f "$rep/unofficial.zip"

	echo "Contenu installé !"
}
fi

echo

exit 0
